/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.hash.Hashing;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;

public final class HmacFunctions {
    private HmacFunctions() {
    }

    @Description(value="Compute HMAC with MD5")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacMd5(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return Slices.wrappedBuffer((byte[])Hashing.hmacMd5((byte[])key.getBytes()).hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="Compute HMAC with SHA1")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha1(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return Slices.wrappedBuffer((byte[])Hashing.hmacSha1((byte[])key.getBytes()).hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="Compute HMAC with SHA256")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha256(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return Slices.wrappedBuffer((byte[])Hashing.hmacSha256((byte[])key.getBytes()).hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="Compute HMAC with SHA512")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha512(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return Slices.wrappedBuffer((byte[])Hashing.hmacSha512((byte[])key.getBytes()).hashBytes(slice.getBytes()).asBytes());
    }
}

