/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.gen.lambda.LambdaFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class InvokeFunction
extends SqlScalarFunction {
    public static final InvokeFunction INVOKE_FUNCTION = new InvokeFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(InvokeFunction.class, "invoke", InvokeLambda.class);

    private InvokeFunction() {
        super(new Signature("invoke", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"function(T)")), false));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "lambda invoke function";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type returnType = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(InvokeLambda.class)), METHOD_HANDLE.asType(METHOD_HANDLE.type().changeReturnType(Primitives.wrap((Class)returnType.getJavaType()))), this.isDeterministic());
    }

    public static Object invoke(InvokeLambda function) {
        return function.apply();
    }

    @FunctionalInterface
    public static interface InvokeLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }
}

