/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.Chars;

public final class JoniRegexpCasts {
    private JoniRegexpCasts() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="JoniRegExp")
    public static Regex castVarcharToJoniRegexp(@SqlType(value="varchar(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(pattern);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="JoniRegExp")
    public static Regex castCharToJoniRegexp(@LiteralParameter(value="x") Long charLength, @SqlType(value="char(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(Chars.padSpaces((Slice)pattern, (int)charLength.intValue()));
    }

    public static Regex joniRegexp(Slice pattern) {
        Regex regex;
        try {
            regex = new Regex(pattern.getBytes(), 0, pattern.length(), 0, (Encoding)NonStrictUTF8Encoding.INSTANCE, Syntax.Java);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        return regex;
    }
}

