/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.VarArgsToArrayAdapterGenerator;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class MapConcatFunction
extends SqlScalarFunction {
    public static final MapConcatFunction MAP_CONCAT_FUNCTION = new MapConcatFunction();
    private static final String FUNCTION_NAME = "map_concat";
    private static final String DESCRIPTION = "Concatenates given maps";
    private static final MethodHandle USER_STATE_FACTORY = Reflection.methodHandle(MapConcatFunction.class, "createMapState", MapType.class);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConcatFunction.class, "mapConcat", MapType.class, Object.class, Block[].class);

    private MapConcatFunction() {
        super(new Signature(FUNCTION_NAME, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)")), true));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments to map_concat");
        }
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MapType mapType = (MapType)typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Block.class, Block.class, arity, METHOD_HANDLE.bindTo(mapType), USER_STATE_FACTORY.bindTo(mapType));
        return new ScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()), this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Object createMapState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    @UsedByGeneratedCode
    public static Block mapConcat(MapType mapType, Object state, Block[] maps) {
        int i;
        int lastMapIndex;
        int entries = 0;
        int firstMapIndex = lastMapIndex = maps.length - 1;
        for (int i2 = 0; i2 < maps.length; ++i2) {
            entries += maps[i2].getPositionCount();
            if (maps[i2].getPositionCount() <= 0) continue;
            lastMapIndex = i2;
            firstMapIndex = Math.min(firstMapIndex, i2);
        }
        if (lastMapIndex == firstMapIndex) {
            return maps[lastMapIndex];
        }
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        TypedSet typedSet = new TypedSet(keyType, entries / 2, FUNCTION_NAME);
        BlockBuilder mapBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        Block map = maps[lastMapIndex];
        for (i = 0; i < map.getPositionCount(); i += 2) {
            typedSet.add(map, i);
            keyType.appendTo(map, i, blockBuilder);
            valueType.appendTo(map, i + 1, blockBuilder);
        }
        for (int idx = lastMapIndex - 1; idx > firstMapIndex; --idx) {
            map = maps[idx];
            for (int i3 = 0; i3 < map.getPositionCount(); i3 += 2) {
                if (typedSet.contains(map, i3)) continue;
                typedSet.add(map, i3);
                keyType.appendTo(map, i3, blockBuilder);
                valueType.appendTo(map, i3 + 1, blockBuilder);
            }
        }
        map = maps[firstMapIndex];
        for (i = 0; i < map.getPositionCount(); i += 2) {
            if (typedSet.contains(map, i)) continue;
            keyType.appendTo(map, i, blockBuilder);
            valueType.appendTo(map, i + 1, blockBuilder);
        }
        mapBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

