/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.relational.Signatures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MapSubscriptOperator
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", InterpretedFunctionInvoker.class, Type.class, Type.class, ConnectorSession.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", InterpretedFunctionInvoker.class, Type.class, Type.class, ConnectorSession.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", InterpretedFunctionInvoker.class, Type.class, Type.class, ConnectorSession.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", InterpretedFunctionInvoker.class, Type.class, Type.class, ConnectorSession.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", InterpretedFunctionInvoker.class, Type.class, Type.class, ConnectorSession.class, Block.class, Object.class);

    public MapSubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)"), (Object)TypeSignature.parseTypeSignature((String)"K")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (keyType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(functionRegistry);
        methodHandle = methodHandle.bindTo(functionInvoker).bindTo(keyType).bindTo(valueType);
        methodHandle = methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Object subscript(InterpretedFunctionInvoker functionInvoker, Type keyType, Type valueType, ConnectorSession session, Block map, boolean key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(InterpretedFunctionInvoker functionInvoker, Type keyType, Type valueType, ConnectorSession session, Block map, long key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(InterpretedFunctionInvoker functionInvoker, Type keyType, Type valueType, ConnectorSession session, Block map, double key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(InterpretedFunctionInvoker functionInvoker, Type keyType, Type valueType, ConnectorSession session, Block map, Slice key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object subscript(InterpretedFunctionInvoker functionInvoker, Type keyType, Type valueType, ConnectorSession session, Block map, Object key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact((Block)key);
        if (valuePosition == -1) {
            throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    private static RuntimeException throwMissingKeyException(Type type, InterpretedFunctionInvoker functionInvoker, Object value, ConnectorSession session) {
        String stringValue;
        try {
            stringValue = ((Slice)functionInvoker.invoke(Signatures.castSignature((Type)VarcharType.VARCHAR, type), session, value)).toStringUtf8();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key not present in map");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Key not present in map: %s", stringValue));
    }
}

