/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.Constraint;
import io.prestosql.type.Re2JRegexp;

public final class Re2JRegexpFunctions {
    private Re2JRegexpFunctions() {
    }

    @Description(value="returns substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.matches(source);
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @LiteralParameters(value={"x", "y", "z"})
    @Constraint(variable="z", expression="min(2147483647, x + max(x * y / 2, y) * (x + 1))")
    @SqlType(value="varchar(z)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="varchar(y)") Slice replacement) {
        return pattern.replace(source, replacement);
    }

    @Description(value="string(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtractAll(source, pattern, 0L);
    }

    @Description(value="group(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extractAll(source, groupIndex);
    }

    @SqlNullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @SqlNullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extract(source, groupIndex);
    }

    @ScalarFunction
    @Description(value="returns array of strings split by pattern")
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpSplit(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.split(source);
    }
}

