/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.List;

public abstract class RowComparisonOperator
extends SqlOperator {
    protected RowComparisonOperator(OperatorType operatorType) {
        super(operatorType, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    protected List<MethodHandle> getMethodHandles(RowType type, FunctionRegistry functionRegistry, OperatorType operatorType) {
        ImmutableList.Builder argumentMethods = ImmutableList.builder();
        for (Type parameterType : type.getTypeParameters()) {
            Signature signature = functionRegistry.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)parameterType, (Object)parameterType));
            argumentMethods.add((Object)functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle());
        }
        return argumentMethods.build();
    }

    protected static int compare(RowType rowType, List<MethodHandle> comparisonFunctions, Block leftRow, Block rightRow) {
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            TypeUtils.checkElementNotNull(leftRow.isNull(i), "null value at position " + i);
            TypeUtils.checkElementNotNull(rightRow.isNull(i), "null value at position " + i);
            Type type = (Type)rowType.getTypeParameters().get(i);
            Object leftElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)leftRow, (int)i);
            Object rightElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)rightRow, (int)i);
            try {
                if (comparisonFunctions.get(i).invoke(leftElement, rightElement)) {
                    return 1;
                }
                if (!comparisonFunctions.get(i).invoke(rightElement, leftElement)) continue;
                return -1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0;
    }
}

