/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RowDistinctFromOperator
extends SqlOperator {
    public static final RowDistinctFromOperator ROW_DISTINCT_FROM = new RowDistinctFromOperator();
    private static final MethodHandle METHOD_HANDLE_NULL_FLAG = Reflection.methodHandle(RowDistinctFromOperator.class, "isDistinctFrom", Type.class, List.class, Block.class, Boolean.TYPE, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_BLOCK_POSITION = Reflection.methodHandle(RowDistinctFromOperator.class, "isDistinctFrom", Type.class, List.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE);

    private RowDistinctFromOperator() {
        super(OperatorType.IS_DISTINCT_FROM, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        ImmutableList.Builder argumentMethods = ImmutableList.builder();
        Type type = boundVariables.getTypeVariable("T");
        for (Type parameterType : type.getTypeParameters()) {
            Signature signature = functionRegistry.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List<? extends Type>)ImmutableList.of((Object)parameterType, (Object)parameterType));
            FunctionInvoker functionInvoker = functionRegistry.getFunctionInvokerProvider().createFunctionInvoker(signature, Optional.of(new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false)));
            argumentMethods.add((Object)functionInvoker.methodHandle());
        }
        return new ScalarFunctionImplementation((List<ScalarFunctionImplementation.ScalarImplementationChoice>)ImmutableList.of((Object)new ScalarFunctionImplementation.ScalarImplementationChoice(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)), METHOD_HANDLE_NULL_FLAG.bindTo(type).bindTo(argumentMethods.build()), Optional.empty()), (Object)new ScalarFunctionImplementation.ScalarImplementationChoice(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION)), METHOD_HANDLE_BLOCK_POSITION.bindTo(type).bindTo(argumentMethods.build()), Optional.empty())), this.isDeterministic());
    }

    public static boolean isDistinctFrom(Type rowType, List<MethodHandle> argumentMethods, Block leftRow, boolean leftNull, Block rightRow, boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        List fieldTypes = rowType.getTypeParameters();
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            Object rightValue;
            boolean rightValueNull;
            boolean leftValueNull;
            Type type = (Type)fieldTypes.get(i);
            Object leftValue = TypeUtils.readNativeValue((Type)type, (Block)leftRow, (int)i);
            boolean bl = leftValueNull = leftValue == null;
            if (leftValueNull) {
                leftValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            boolean bl2 = rightValueNull = (rightValue = TypeUtils.readNativeValue((Type)type, (Block)rightRow, (int)i)) == null;
            if (rightValueNull) {
                rightValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            try {
                if (!argumentMethods.get(i).invoke(leftValue, leftValueNull, rightValue, rightValueNull)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }

    public static boolean isDistinctFrom(Type rowType, List<MethodHandle> argumentMethods, Block leftRow, int leftPosition, Block rightRow, int rightPosition) {
        return RowDistinctFromOperator.isDistinctFrom(rowType, argumentMethods, (Block)rowType.getObject(leftRow, leftPosition), leftRow.isNull(leftPosition), (Block)rowType.getObject(rightRow, rightPosition), rightRow.isNull(rightPosition));
    }
}

