/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RowEqualOperator
extends SqlOperator {
    public static final RowEqualOperator ROW_EQUAL = new RowEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowEqualOperator.class, "equals", RowType.class, List.class, Block.class, Block.class);

    private RowEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        RowType type = (RowType)boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(type).bindTo(RowEqualOperator.resolveFieldEqualOperators(type, functionRegistry)), this.isDeterministic());
    }

    public static List<MethodHandle> resolveFieldEqualOperators(RowType rowType, FunctionRegistry functionRegistry) {
        return (List)rowType.getTypeParameters().stream().map(type -> RowEqualOperator.resolveEqualOperator(type, functionRegistry)).collect(ImmutableList.toImmutableList());
    }

    private static MethodHandle resolveEqualOperator(Type type, FunctionRegistry functionRegistry) {
        Signature operator = functionRegistry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type));
        ScalarFunctionImplementation implementation = functionRegistry.getScalarFunctionImplementation(operator);
        return implementation.getMethodHandle();
    }

    public static Boolean equals(RowType rowType, List<MethodHandle> fieldEqualOperators, Block leftRow, Block rightRow) {
        boolean indeterminate = false;
        for (int fieldIndex = 0; fieldIndex < leftRow.getPositionCount(); ++fieldIndex) {
            if (leftRow.isNull(fieldIndex) || rightRow.isNull(fieldIndex)) {
                indeterminate = true;
                continue;
            }
            Type fieldType = (Type)rowType.getTypeParameters().get(fieldIndex);
            Object leftField = TypeUtils.readNativeValue((Type)fieldType, (Block)leftRow, (int)fieldIndex);
            Object rightField = TypeUtils.readNativeValue((Type)fieldType, (Block)rightRow, (int)fieldIndex);
            try {
                MethodHandle equalOperator = fieldEqualOperators.get(fieldIndex);
                Boolean result = equalOperator.invoke(leftField, rightField);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }
}

