/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class TryCastFunction
extends SqlScalarFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();

    public TryCastFunction() {
        super(new Signature("TRY_CAST", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("F"), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"F")), false));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        Signature signature = functionRegistry.getCoercion(fromType, toType);
        ScalarFunctionImplementation implementation = functionRegistry.getScalarFunctionImplementation(signature);
        ImmutableList argumentProperties = ImmutableList.of((Object)implementation.getArgumentProperty(0));
        MethodHandle coercion = implementation.getMethodHandle();
        coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
        MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
        MethodHandle tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)argumentProperties, tryCastHandle, this.isDeterministic());
    }
}

