/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.gen.lambda.BinaryFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ZipWithFunction
extends SqlScalarFunction {
    public static final ZipWithFunction ZIP_WITH_FUNCTION = new ZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ZipWithFunction.class, "zipWith", Type.class, Type.class, ArrayType.class, Object.class, Block.class, Block.class, BinaryFunctionInterface.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ZipWithFunction.class, "createState", ArrayType.class);

    private ZipWithFunction() {
        super(new Signature("zip_with", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("U"), (Object)Signature.typeVariable("R")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(R)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"array(U)"), (Object)TypeSignature.parseTypeSignature((String)"function(T,U,R)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "merge two arrays, element-wise, into a single array using the lambda function";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type leftElementType = boundVariables.getTypeVariable("T");
        Type rightElementType = boundVariables.getTypeVariable("U");
        Type outputElementType = boundVariables.getTypeVariable("R");
        ArrayType outputArrayType = new ArrayType(outputElementType);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(BinaryFunctionInterface.class)), METHOD_HANDLE.bindTo(leftElementType).bindTo(rightElementType).bindTo(outputArrayType), Optional.of(STATE_FACTORY.bindTo(outputArrayType)), this.isDeterministic());
    }

    public static Object createState(ArrayType arrayType) {
        return new PageBuilder((List)ImmutableList.of((Object)arrayType));
    }

    public static Block zipWith(Type leftElementType, Type rightElementType, ArrayType outputArrayType, Object state, Block leftBlock, Block rightBlock, BinaryFunctionInterface function) {
        Type outputElementType = outputArrayType.getElementType();
        int leftPositionCount = leftBlock.getPositionCount();
        int rightPositionCount = rightBlock.getPositionCount();
        int outputPositionCount = Math.max(leftPositionCount, rightPositionCount);
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder arrayBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = arrayBlockBuilder.beginBlockEntry();
        for (int position = 0; position < outputPositionCount; ++position) {
            Object output;
            Object left = position < leftPositionCount ? TypeUtils.readNativeValue((Type)leftElementType, (Block)leftBlock, (int)position) : null;
            Object right = position < rightPositionCount ? TypeUtils.readNativeValue((Type)rightElementType, (Block)rightBlock, (int)position) : null;
            try {
                output = function.apply(left, right);
            }
            catch (Throwable throwable) {
                arrayBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            TypeUtils.writeNativeValue((Type)outputElementType, (BlockBuilder)blockBuilder, (Object)output);
        }
        arrayBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return outputArrayType.getObject((Block)arrayBlockBuilder, arrayBlockBuilder.getPositionCount() - 1);
    }
}

