/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.aggregation.Accumulator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.window.AbstractWindowFunctionSupplier;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.WindowFunction;
import io.prestosql.spi.function.WindowIndex;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AggregateWindowFunction
implements WindowFunction {
    private final List<Integer> argumentChannels;
    private final AccumulatorFactory accumulatorFactory;
    private WindowIndex windowIndex;
    private Accumulator accumulator;
    private int currentStart;
    private int currentEnd;

    private AggregateWindowFunction(InternalAggregationFunction function, List<Integer> argumentChannels) {
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
        this.accumulatorFactory = function.bind(AggregateWindowFunction.createArgs(function), Optional.empty());
    }

    public void reset(WindowIndex windowIndex) {
        this.windowIndex = windowIndex;
        this.resetAccumulator();
    }

    public void processRow(BlockBuilder output, int peerGroupStart, int peerGroupEnd, int frameStart, int frameEnd) {
        if (frameStart < 0) {
            this.resetAccumulator();
        } else if (frameStart == this.currentStart && frameEnd >= this.currentEnd) {
            this.accumulate(this.currentEnd + 1, frameEnd);
            this.currentEnd = frameEnd;
        } else {
            this.resetAccumulator();
            this.accumulate(frameStart, frameEnd);
            this.currentStart = frameStart;
            this.currentEnd = frameEnd;
        }
        this.accumulator.evaluateFinal(output);
    }

    private void accumulate(int start, int end) {
        this.accumulator.addInput(this.windowIndex, this.argumentChannels, start, end);
    }

    private void resetAccumulator() {
        if (this.currentStart >= 0) {
            this.accumulator = this.accumulatorFactory.createAccumulator();
            this.currentStart = -1;
            this.currentEnd = -1;
        }
    }

    public static WindowFunctionSupplier supplier(Signature signature, final InternalAggregationFunction function) {
        Objects.requireNonNull(function, "function is null");
        return new AbstractWindowFunctionSupplier(signature, null){

            @Override
            protected WindowFunction newWindowFunction(List<Integer> inputs) {
                return new AggregateWindowFunction(function, inputs);
            }
        };
    }

    private static List<Integer> createArgs(InternalAggregationFunction function) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < function.getParameterTypes().size(); ++i) {
            list.add((Object)i);
        }
        return list.build();
    }
}

