/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.collect.Iterables;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.ValueWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import java.util.List;

@WindowFunctionSignature(name="first_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class FirstValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;

    public FirstValueFunction(List<Integer> argumentChannels) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        this.windowIndex.appendTo(this.argumentChannel, frameStart, output);
    }
}

