/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.base.MoreObjects;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.WindowFrame;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowFrame.Type type;
    private final FrameBound.Type startType;
    private final int startChannel;
    private final FrameBound.Type endType;
    private final int endChannel;

    public FrameInfo(WindowFrame.Type type, FrameBound.Type startType, Optional<Integer> startChannel, FrameBound.Type endType, Optional<Integer> endChannel) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = Objects.requireNonNull(startChannel, "startChannel is null").orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = Objects.requireNonNull(endChannel, "endChannel is null").orElse(-1);
    }

    public WindowFrame.Type getType() {
        return this.type;
    }

    public FrameBound.Type getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public FrameBound.Type getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.startType, this.startChannel, this.endType, this.endChannel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameInfo other = (FrameInfo)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.startType, other.startType) && Objects.equals(this.startChannel, other.startChannel) && Objects.equals(this.endType, other.endType) && Objects.equals(this.endChannel, other.endChannel);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("endType", (Object)this.endType).add("endChannel", this.endChannel).toString();
    }
}

