/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllSystemAccessControl;
import io.prestosql.security.FileBasedSystemAccessControl;
import io.prestosql.security.ReadOnlySystemAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemAccessControlFactory;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.PropertiesUtil;
import java.io.File;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File ACCESS_CONTROL_CONFIGURATION = new File("etc/access-control.properties");
    private static final String ACCESS_CONTROL_PROPERTY_NAME = "access-control.name";
    private final TransactionManager transactionManager;
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final Map<CatalogName, CatalogAccessControlEntry> connectorAccessControl = new ConcurrentHashMap<CatalogName, CatalogAccessControlEntry>();
    private final AtomicReference<SystemAccessControl> systemAccessControl = new AtomicReference<InitializingSystemAccessControl>(new InitializingSystemAccessControl());
    private final AtomicBoolean systemAccessControlLoading = new AtomicBoolean();
    private final CounterStat authenticationSuccess = new CounterStat();
    private final CounterStat authenticationFail = new CounterStat();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.addSystemAccessControlFactory(new AllowAllSystemAccessControl.Factory());
        this.addSystemAccessControlFactory(new ReadOnlySystemAccessControl.Factory());
        this.addSystemAccessControlFactory(new FileBasedSystemAccessControl.Factory());
    }

    public void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void addCatalogAccessControl(CatalogName catalogName, ConnectorAccessControl accessControl) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        Preconditions.checkState((this.connectorAccessControl.putIfAbsent(catalogName, new CatalogAccessControlEntry(catalogName, accessControl)) == null ? 1 : 0) != 0, (String)"Access control for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeCatalogAccessControl(CatalogName catalogName) {
        this.connectorAccessControl.remove(catalogName);
    }

    public void loadSystemAccessControl() throws Exception {
        if (ACCESS_CONTROL_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(ACCESS_CONTROL_CONFIGURATION));
            String accessControlName = (String)properties.remove(ACCESS_CONTROL_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessControlName) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object)ACCESS_CONTROL_CONFIGURATION.getAbsoluteFile(), (Object)ACCESS_CONTROL_PROPERTY_NAME);
            this.setSystemAccessControl(accessControlName, properties);
        } else {
            this.setSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
        }
    }

    @VisibleForTesting
    protected void setSystemAccessControl(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        Preconditions.checkState((boolean)this.systemAccessControlLoading.compareAndSet(false, true), (Object)"System access control already initialized");
        log.info("-- Loading system access control --");
        SystemAccessControlFactory systemAccessControlFactory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((systemAccessControlFactory != null ? 1 : 0) != 0, (String)"Access control %s is not registered", (Object)name);
        SystemAccessControl systemAccessControl = systemAccessControlFactory.create((Map)ImmutableMap.copyOf(properties));
        this.systemAccessControl.set(systemAccessControl);
        log.info("-- Loaded system access control %s --", new Object[]{name});
    }

    @Override
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanSetUser(principal, userName));
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogs, "catalogs is null");
        return this.systemAccessControl.get().filterCatalogs(identity, catalogs);
    }

    @Override
    public void checkCanAccessCatalog(Identity identity, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalog is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanAccessCatalog(identity, catalogName));
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateSchema(identity, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), schemaName.getSchemaName()));
        }
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropSchema(identity, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), schemaName.getSchemaName()));
        }
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName, String newSchemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameSchema(identity, schemaName, newSchemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), schemaName.getSchemaName(), newSchemaName));
        }
    }

    @Override
    public void checkCanShowSchemas(TransactionId transactionId, Identity identity, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanShowSchemas(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanShowSchemas(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName)));
        }
    }

    @Override
    public Set<String> filterSchemas(TransactionId transactionId, Identity identity, String catalogName, Set<String> schemaNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaNames, "schemaNames is null");
        if (this.filterCatalogs(identity, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        schemaNames = this.systemAccessControl.get().filterSchemas(identity, catalogName, schemaNames);
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            schemaNames = entry.getAccessControl().filterSchemas(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), schemaNames);
        }
        return schemaNames;
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameTable(identity, tableName.asCatalogSchemaTableName(), newTableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName(), newTableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSetTableComment(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetTableComment(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetTableComment(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanShowTablesMetadata(TransactionId transactionId, Identity identity, CatalogSchemaName schema) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schema, "schema is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, schema.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanShowTablesMetadata(identity, schema));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schema.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanShowTablesMetadata(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(), schema.getSchemaName()));
        }
    }

    @Override
    public Set<SchemaTableName> filterTables(TransactionId transactionId, Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableNames, "tableNames is null");
        if (this.filterCatalogs(identity, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        tableNames = this.systemAccessControl.get().filterTables(identity, catalogName, tableNames);
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            tableNames = entry.getAccessControl().filterTables(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), tableNames);
        }
        return tableNames;
    }

    @Override
    public void checkCanShowColumnsMetadata(TransactionId transactionId, Identity identity, CatalogSchemaTableName table) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(table, "table is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanShowColumnsMetadata(identity, table));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, table.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanShowColumnsMetadata(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(), table.getSchemaTableName()));
        }
    }

    @Override
    public List<ColumnMetadata> filterColumns(TransactionId transactionId, Identity identity, CatalogSchemaTableName table, List<ColumnMetadata> columns) {
        Objects.requireNonNull(transactionId, "transaction is null");
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(table, "tableName is null");
        if (this.filterTables(transactionId, identity, table.getCatalogName(), (Set<SchemaTableName>)ImmutableSet.of((Object)table.getSchemaTableName())).isEmpty()) {
            return ImmutableList.of();
        }
        columns = this.systemAccessControl.get().filterColumns(identity, table, columns);
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, table.getCatalogName());
        if (entry != null) {
            columns = entry.getAccessControl().filterColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(), table.getSchemaTableName(), columns);
        }
        return columns;
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanAddColumn(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanAddColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropColumn(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameColumn(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanInsertIntoTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanInsertIntoTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDeleteFromTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDeleteFromTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, viewName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateView(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(viewName.getCatalogName()), viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, viewName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropView(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(viewName.getCatalogName()), viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateViewWithSelectFromColumns(identity, tableName.asCatalogSchemaTableName(), columnNames));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateViewWithSelectFromColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName(), columnNames));
        }
    }

    @Override
    public void checkCanGrantTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanGrantTablePrivilege(identity, privilege, tableName.asCatalogSchemaTableName(), grantee, withGrantOption));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanGrantTablePrivilege(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), privilege, tableName.asSchemaTableName(), grantee, withGrantOption));
        }
    }

    @Override
    public void checkCanRevokeTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRevokeTablePrivilege(identity, privilege, tableName.asCatalogSchemaTableName(), revokee, grantOptionFor));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRevokeTablePrivilege(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), privilege, tableName.asSchemaTableName(), revokee, grantOptionFor));
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetSystemSessionProperty(identity, propertyName));
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, String catalogName, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetCatalogSessionProperty(identity, catalogName, propertyName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetCatalogSessionProperty(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), propertyName));
        }
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSelectFromColumns(identity, tableName.asCatalogSchemaTableName(), columnNames));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSelectFromColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), tableName.asSchemaTableName(), columnNames));
        }
    }

    @Override
    public void checkCanCreateRole(TransactionId transactionId, Identity identity, String role, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), role, grantor));
        }
    }

    @Override
    public void checkCanDropRole(TransactionId transactionId, Identity identity, String role, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), role));
        }
    }

    @Override
    public void checkCanGrantRoles(TransactionId transactionId, Identity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanGrantRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), roles, grantees, withAdminOption, grantor, catalogName));
        }
    }

    @Override
    public void checkCanRevokeRoles(TransactionId transactionId, Identity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRevokeRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), roles, grantees, adminOptionFor, grantor, catalogName));
        }
    }

    @Override
    public void checkCanSetRole(TransactionId transactionId, Identity identity, String role, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalog is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), role, catalogName));
        }
    }

    @Override
    public void checkCanShowRoles(TransactionId transactionId, Identity identity, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), catalogName));
        }
    }

    @Override
    public void checkCanShowCurrentRoles(TransactionId transactionId, Identity identity, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowCurrentRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), catalogName));
        }
    }

    @Override
    public void checkCanShowRoleGrants(TransactionId transactionId, Identity identity, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowRoleGrants(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), catalogName));
        }
    }

    private CatalogAccessControlEntry getConnectorAccessControl(TransactionId transactionId, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).map(metadata -> this.connectorAccessControl.get(metadata.getCatalogName())).orElse(null);
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationSuccess() {
        return this.authenticationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationFail() {
        return this.authenticationFail;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void authenticationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authenticationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authenticationFail.update(1L);
            throw e;
        }
    }

    private void authorizationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authorizationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private static class InitializingSystemAccessControl
    implements SystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        public void checkCanSetUser(Optional<Principal> principal, String userName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanAccessCatalog(Identity identity, String catalogName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }
    }

    private class CatalogAccessControlEntry {
        private final CatalogName catalogName;
        private final ConnectorAccessControl accessControl;

        public CatalogAccessControlEntry(CatalogName catalogName, ConnectorAccessControl accessControl) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public ConnectorAccessControl getAccessControl() {
            return this.accessControl;
        }

        public ConnectorTransactionHandle getTransactionHandle(TransactionId transactionId) {
            return AccessControlManager.this.transactionManager.getConnectorTransaction(transactionId, this.catalogName);
        }
    }
}

