/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class CatalogAccessControlRule {
    private final boolean allow;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> catalogRegex;

    @JsonCreator
    public CatalogAccessControlRule(@JsonProperty(value="allow") boolean allow, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.allow = allow;
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    public Optional<Boolean> match(String user, String catalog) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.catalogRegex.map(regex -> regex.matcher(catalog).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

