/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.SessionRepresentation;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.server.BasicQueryStats;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.ErrorType;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final QueryState state;
    private final MemoryPoolId memoryPool;
    private final boolean scheduled;
    private final URI self;
    private final String query;
    private final BasicQueryStats queryStats;
    private final ErrorType errorType;
    private final ErrorCode errorCode;

    @JsonCreator
    public BasicQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="memoryPool") MemoryPoolId memoryPool, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="query") String query, @JsonProperty(value="queryStats") BasicQueryStats queryStats, @JsonProperty(value="errorType") ErrorType errorType, @JsonProperty(value="errorCode") ErrorCode errorCode) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.memoryPool = memoryPool;
        this.errorType = errorType;
        this.errorCode = errorCode;
        this.scheduled = scheduled;
        this.self = Objects.requireNonNull(self, "self is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getState(), queryInfo.getMemoryPool(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getQuery(), new BasicQueryStats(queryInfo.getQueryStats()), queryInfo.getErrorType(), queryInfo.getErrorCode());
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public MemoryPoolId getMemoryPool() {
        return this.memoryPool;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public BasicQueryStats getQueryStats() {
        return this.queryStats;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

