/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.reflect.TypeToken;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.prestosql.execution.buffer.PagesSerdeUtil;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.spi.Page;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/X-presto-pages"})
public class PagesResponseWriter
implements MessageBodyWriter<List<SerializedPage>> {
    private static final MediaType PRESTO_PAGES_TYPE = MediaType.valueOf((String)"application/X-presto-pages");
    private static final Type LIST_GENERIC_TOKEN;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && TypeToken.of((Type)genericType).resolveType(LIST_GENERIC_TOKEN).getRawType().equals(Page.class) && mediaType.isCompatible(PRESTO_PAGES_TYPE);
    }

    public long getSize(List<SerializedPage> serializedPages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<SerializedPage> serializedPages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output) throws IOException, WebApplicationException {
        block2: {
            try {
                OutputStreamSliceOutput sliceOutput = new OutputStreamSliceOutput(output);
                PagesSerdeUtil.writeSerializedPages((SliceOutput)sliceOutput, serializedPages);
                sliceOutput.flush();
            }
            catch (UncheckedIOException e) {
                if (e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
    }

    static {
        try {
            LIST_GENERIC_TOKEN = List.class.getMethod("get", Integer.TYPE).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

