/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import io.prestosql.connector.system.KillQueryProcedure;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.StageId;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/query")
public class QueryResource {
    private final QueryManager queryManager;

    @Inject
    public QueryResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String stateFilter) {
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BasicQueryInfo queryInfo : this.queryManager.getQueries()) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)queryInfo);
        }
        return builder.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getFullQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        this.queryManager.cancelQuery(queryId);
    }

    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message) {
        return this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message));
    }

    @PUT
    @Path(value="{queryId}/preempted")
    public Response preemptQuery(@PathParam(value="queryId") QueryId queryId, String message) {
        return this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message));
    }

    private Response failQuery(QueryId queryId, PrestoException queryException) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryState state = this.queryManager.getQueryState(queryId);
            if (state.isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.queryManager.failQuery(queryId, queryException);
            if (!queryException.getErrorCode().equals((Object)this.queryManager.getQueryInfo(queryId).getErrorCode())) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

