/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.server.ResourceGroupInfo;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/resourceGroupState")
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;

    @Inject
    public ResourceGroupStateInfoResource(ResourceGroupManager<?> resourceGroupManager) {
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public ResourceGroupInfo getQueryStateInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString) {
        if (!Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            try {
                return this.resourceGroupManager.getResourceGroupInfo(new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList())));
            }
            catch (NoSuchElementException e) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }
}

