/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.protocol;

import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryState;
import io.prestosql.server.protocol.Query;
import io.prestosql.spi.QueryId;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;

class PurgeQueriesRunnable
implements Runnable {
    private static final Logger log = Logger.get(PurgeQueriesRunnable.class);
    private final ConcurrentMap<QueryId, Query> queries;
    private final QueryManager queryManager;

    public PurgeQueriesRunnable(ConcurrentMap<QueryId, Query> queries, QueryManager queryManager) {
        this.queries = queries;
        this.queryManager = queryManager;
    }

    @Override
    public void run() {
        try {
            for (QueryId queryId : ImmutableSet.copyOf(this.queries.keySet())) {
                Query query = (Query)this.queries.get(queryId);
                if (!query.isSubmissionFinished()) continue;
                try {
                    if (this.queryManager.getQueryState(queryId) != QueryState.FAILED) continue;
                    query.dispose();
                }
                catch (NoSuchElementException e) {
                    query.dispose();
                    this.queries.remove(queryId);
                }
            }
        }
        catch (Throwable e) {
            log.warn(e, "Error removing old queries");
        }
    }
}

