/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.prestosql.server.security.AuthenticationException;
import io.prestosql.server.security.Authenticator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
implements Filter {
    private final List<Authenticator> authenticators;

    @Inject
    public AuthenticationFilter(List<Authenticator> authenticators) {
        this.authenticators = ImmutableList.copyOf(authenticators);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain nextFilter) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!request.isSecure() || this.authenticators.isEmpty()) {
            nextFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        LinkedHashSet authenticateHeaders = new LinkedHashSet();
        for (Authenticator authenticator : this.authenticators) {
            Principal principal;
            try {
                principal = authenticator.authenticate(request);
            }
            catch (AuthenticationException e) {
                if (e.getMessage() != null) {
                    messages.add(e.getMessage());
                }
                e.getAuthenticateHeader().ifPresent(authenticateHeaders::add);
                continue;
            }
            nextFilter.doFilter(AuthenticationFilter.withPrincipal(request, principal), (ServletResponse)response);
            return;
        }
        AuthenticationFilter.skipRequestBody(request);
        for (String value : authenticateHeaders) {
            response.addHeader("WWW-Authenticate", value);
        }
        if (messages.isEmpty()) {
            messages.add("Unauthorized");
        }
        response.sendError(401, Joiner.on((String)" | ").join(messages));
    }

    private static ServletRequest withPrincipal(HttpServletRequest request, final Principal principal) {
        Objects.requireNonNull(principal, "principal is null");
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)ByteStreams.nullOutputStream());
        }
    }
}

