/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.split;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.metadata.Split;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.split.SplitSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final CatalogName catalogName;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(CatalogName catalogName, ConnectorSplitSource source) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        ListenableFuture nextBatch = MoreFutures.toListenableFuture((CompletableFuture)this.source.getNextBatch(partitionHandle, maxSize));
        return Futures.transform((ListenableFuture)nextBatch, splitBatch -> {
            ImmutableList.Builder result = ImmutableList.builder();
            for (ConnectorSplit connectorSplit : splitBatch.getSplits()) {
                result.add((Object)new Split(this.catalogName, connectorSplit, lifespan));
            }
            return new SplitSource.SplitBatch((List<Split>)result.build(), splitBatch.isNoMoreSplits());
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    public String toString() {
        return this.catalogName + ":" + this.source;
    }
}

