/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.prestosql.sql.ExpressionFormatter;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;

public final class Serialization {
    private Serialization() {
    }

    public static class FunctionCallDeserializer
    extends JsonDeserializer<FunctionCall> {
        private final SqlParser sqlParser;

        @Inject
        public FunctionCallDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public FunctionCall deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (FunctionCall)ExpressionUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class)));
        }
    }

    public static class ExpressionDeserializer
    extends JsonDeserializer<Expression> {
        private final SqlParser sqlParser;

        @Inject
        public ExpressionDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return ExpressionUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class)));
        }
    }

    public static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(ExpressionFormatter.formatExpression((Expression)expression, Optional.empty()));
        }
    }
}

