/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.SqlFormatter;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Optional;

public final class SqlFormatterUtil {
    private SqlFormatterUtil() {
    }

    public static String getFormattedSql(Statement statement, SqlParser sqlParser, Optional<List<Expression>> parameters) {
        Statement parsed;
        String sql = SqlFormatter.formatSql((Node)statement, parameters);
        try {
            ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.REJECT);
            parsed = sqlParser.createStatement(sql, parsingOptions);
        }
        catch (ParsingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Formatted query does not parse: " + statement);
        }
        if (!statement.equals((Object)parsed)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query does not round-trip: " + statement);
        }
        return sql;
    }
}

