/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.ExpressionTreeUtils;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.analyzer.StatementAnalyzer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final List<Expression> parameters;
    private final WarningCollector warningCollector;

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, WarningCollector warningCollector) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.parameters = parameters;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, false);
    }

    public Analysis analyze(Statement statement, boolean isDescribe) {
        Statement rewrittenStatement = StatementRewrite.rewrite(this.session, this.metadata, this.sqlParser, this.queryExplainer, statement, this.parameters, this.accessControl, this.warningCollector);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameters, isDescribe);
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.sqlParser, this.accessControl, this.session, this.warningCollector);
        analyzer.analyze((Node)rewrittenStatement, Optional.empty());
        analysis.getTableColumnReferences().forEach((accessControlInfo, tableColumnReferences) -> tableColumnReferences.forEach((tableName, columns) -> accessControlInfo.getAccessControl().checkCanSelectFromColumns(this.session.getRequiredTransactionId(), accessControlInfo.getIdentity(), (QualifiedObjectName)tableName, (Set<String>)columns)));
        return analysis;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(FunctionRegistry functionRegistry, Expression predicate, String clause) {
        List<GroupingOperation> groupingOperations;
        List<FunctionCall> windowExpressions;
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), functionRegistry);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(aggregates, windowExpressions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate)), groupingOperations = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), GroupingOperation.class)));
        if (!found.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_WINDOWS_OR_GROUPING, (Node)predicate, "%s cannot contain aggregations, window functions or grouping operations: %s", clause, found);
        }
    }
}

