/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.DefaultTraversalVisitor;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import java.util.Set;

public final class ConstantExpressionVerifier {
    private ConstantExpressionVerifier() {
    }

    public static void verifyExpressionIsConstant(Set<NodeRef<Expression>> columnReferences, Expression expression) {
        new ConstantExpressionVerifierVisitor(columnReferences, expression).process((Node)expression, null);
    }

    private static class ConstantExpressionVerifierVisitor
    extends DefaultTraversalVisitor<Void, Void> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final Expression expression;

        public ConstantExpressionVerifierVisitor(Set<NodeRef<Expression>> columnReferences, Expression expression) {
            this.columnReferences = columnReferences;
            this.expression = expression;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
            }
            this.process((Node)node.getBase(), context);
            return null;
        }

        protected Void visitIdentifier(Identifier node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }

        protected Void visitFieldReference(FieldReference node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }
    }
}

