/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class ExpressionTreeUtils {
    private ExpressionTreeUtils() {
    }

    static List<FunctionCall> extractAggregateFunctions(Iterable<? extends Node> nodes, FunctionRegistry functionRegistry) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils.isAggregationPredicate(functionRegistry));
    }

    static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isWindowFunction);
    }

    public static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz) {
        return ExpressionTreeUtils.extractExpressions(nodes, clazz, Predicates.alwaysTrue());
    }

    private static Predicate<FunctionCall> isAggregationPredicate(FunctionRegistry functionRegistry) {
        return functionCall -> (functionRegistry.isAggregationFunction(functionCall.getName()) || functionCall.getFilter().isPresent()) && !functionCall.getWindow().isPresent() || functionCall.getOrderBy().isPresent();
    }

    private static boolean isWindowFunction(FunctionCall functionCall) {
        return functionCall.getWindow().isPresent();
    }

    private static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz, Predicate<T> predicate) {
        Objects.requireNonNull(nodes, "nodes is null");
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)ImmutableList.copyOf(nodes).stream().flatMap(node -> ExpressionTreeUtils.linearizeNodes(node).stream()).filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    private static List<Node> linearizeNodes(Node node) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<Node, Void>(){

            public Node process(Node node, Void context) {
                Node result = (Node)super.process(node, (Object)context);
                nodes.add((Object)node);
                return result;
            }
        }.process(node, null);
        return nodes.build();
    }
}

