/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.RelationId;
import io.prestosql.sql.analyzer.RelationType;
import io.prestosql.sql.analyzer.ResolvedField;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.WithQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Scope {
    private final Optional<Scope> parent;
    private final boolean queryBoundary;
    private final RelationId relationId;
    private final RelationType relation;
    private final Map<String, WithQuery> namedQueries;

    public static Scope create() {
        return Scope.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Scope(Optional<Scope> parent, boolean queryBoundary, RelationId relationId, RelationType relation, Map<String, WithQuery> namedQueries) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.relationId = Objects.requireNonNull(relationId, "relationId is null");
        this.queryBoundary = queryBoundary;
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.namedQueries = ImmutableMap.copyOf(Objects.requireNonNull(namedQueries, "namedQueries is null"));
    }

    public Optional<Scope> getOuterQueryParent() {
        Scope scope = this;
        while (scope.parent.isPresent()) {
            if (scope.queryBoundary) {
                return scope.parent;
            }
            scope = scope.parent.get();
        }
        return Optional.empty();
    }

    public Optional<Scope> getLocalParent() {
        if (!this.queryBoundary) {
            return this.parent;
        }
        return Optional.empty();
    }

    public RelationId getRelationId() {
        return this.relationId;
    }

    public RelationType getRelationType() {
        return this.relation;
    }

    public ResolvedField resolveField(Expression expression, QualifiedName name) {
        return this.tryResolveField(expression, name).orElseThrow(() -> SemanticExceptions.missingAttributeException(expression, name));
    }

    public Optional<ResolvedField> tryResolveField(Expression expression) {
        QualifiedName qualifiedName = Scope.asQualifiedName(expression);
        if (qualifiedName != null) {
            return this.tryResolveField(expression, qualifiedName);
        }
        return Optional.empty();
    }

    private static QualifiedName asQualifiedName(Expression expression) {
        QualifiedName name = null;
        if (expression instanceof Identifier) {
            name = QualifiedName.of((String)((Identifier)expression).getValue());
        } else if (expression instanceof DereferenceExpression) {
            name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
        }
        return name;
    }

    public Optional<ResolvedField> tryResolveField(Expression node, QualifiedName name) {
        return this.resolveField(node, name, 0, true);
    }

    private Optional<ResolvedField> resolveField(Expression node, QualifiedName name, int fieldIndexOffset, boolean local) {
        List<Field> matches = this.relation.resolveFields(name);
        if (matches.size() > 1) {
            throw SemanticExceptions.ambiguousAttributeException(node, name);
        }
        if (matches.size() == 1) {
            return Optional.of(this.asResolvedField((Field)Iterables.getOnlyElement(matches), fieldIndexOffset, local));
        }
        if (Scope.isColumnReference(name, this.relation)) {
            return Optional.empty();
        }
        if (this.parent.isPresent()) {
            return this.parent.get().resolveField(node, name, fieldIndexOffset + this.relation.getAllFieldCount(), local && !this.queryBoundary);
        }
        return Optional.empty();
    }

    private ResolvedField asResolvedField(Field field, int fieldIndexOffset, boolean local) {
        int relationFieldIndex = this.relation.indexOf(field);
        int hierarchyFieldIndex = this.relation.indexOf(field) + fieldIndexOffset;
        return new ResolvedField(this, field, hierarchyFieldIndex, relationFieldIndex, local);
    }

    public boolean isColumnReference(QualifiedName name) {
        Scope current = this;
        while (current != null) {
            if (Scope.isColumnReference(name, current.relation)) {
                return true;
            }
            current = current.parent.orElse(null);
        }
        return false;
    }

    private static boolean isColumnReference(QualifiedName name, RelationType relation) {
        while (name.getPrefix().isPresent()) {
            if (relation.resolveFields(name = (QualifiedName)name.getPrefix().get()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Optional<WithQuery> getNamedQuery(String name) {
        if (this.namedQueries.containsKey(name)) {
            return Optional.of(this.namedQueries.get(name));
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getNamedQuery(name);
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.relationId).toString();
    }

    public static final class Builder {
        private RelationId relationId = RelationId.anonymous();
        private RelationType relationType = new RelationType(new Field[0]);
        private final Map<String, WithQuery> namedQueries = new HashMap<String, WithQuery>();
        private Optional<Scope> parent = Optional.empty();
        private boolean queryBoundary;

        public Builder withRelationType(RelationId relationId, RelationType relationType) {
            this.relationId = Objects.requireNonNull(relationId, "relationId is null");
            this.relationType = Objects.requireNonNull(relationType, "relationType is null");
            return this;
        }

        public Builder withParent(Scope parent) {
            Preconditions.checkArgument((!this.parent.isPresent() ? 1 : 0) != 0, (Object)"parent is already set");
            this.parent = Optional.of(parent);
            return this;
        }

        public Builder withOuterQueryParent(Scope parent) {
            Preconditions.checkArgument((!this.parent.isPresent() ? 1 : 0) != 0, (Object)"parent is already set");
            this.parent = Optional.of(parent);
            this.queryBoundary = true;
            return this;
        }

        public Builder withNamedQuery(String name, WithQuery withQuery) {
            Preconditions.checkArgument((!this.containsNamedQuery(name) ? 1 : 0) != 0, (String)"Query '%s' is already added", (Object)name);
            this.namedQueries.put(name, withQuery);
            return this;
        }

        public boolean containsNamedQuery(String name) {
            return this.namedQueries.containsKey(name);
        }

        public Scope build() {
            return new Scope(this.parent, this.queryBoundary, this.relationId, this.relationType, this.namedQueries);
        }
    }
}

