/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;

public final class SemanticExceptions {
    private SemanticExceptions() {
    }

    public static SemanticException missingAttributeException(Expression node, QualifiedName name) {
        throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", name);
    }

    @Deprecated
    public static SemanticException missingAttributeException(Expression node) {
        throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", node);
    }

    public static SemanticException ambiguousAttributeException(Expression node, QualifiedName name) {
        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", name);
    }

    public static SemanticException notSupportedException(Node node, String notSupportedFeatureDescription) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, node, notSupportedFeatureDescription + " is not supported", new Object[0]);
    }
}

