/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Signature;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Void, Analysis> {
    WindowFunctionValidator() {
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Objects.requireNonNull(analysis, "analysis is null");
        Signature signature = analysis.getFunctionSignature(functionCall);
        if (signature != null && signature.getKind() == FunctionKind.WINDOW && !functionCall.getWindow().isPresent()) {
            throw new SemanticException(SemanticErrorCode.WINDOW_REQUIRES_OVER, (Node)functionCall, "Window function %s requires an OVER clause", signature.getName());
        }
        return (Void)super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

