/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeNode;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.LambdaBytecodeGenerator;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;
import java.util.Map;

public class BindCodeGenerator
implements BytecodeGenerator {
    private final Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap;
    private final Class lambdaInterface;

    public BindCodeGenerator(Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, Class lambdaInterface) {
        this.compiledLambdaMap = compiledLambdaMap;
        this.lambdaInterface = lambdaInterface;
    }

    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        int numCaptures = arguments.size() - 1;
        LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)arguments.get(numCaptures);
        Preconditions.checkState((boolean)this.compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
        LambdaBytecodeGenerator.CompiledLambda compiledLambda = this.compiledLambdaMap.get(lambda);
        return LambdaBytecodeGenerator.generateLambda(context, arguments.subList(0, numCaptures), compiledLambda, this.lambdaInterface);
    }
}

