/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import io.airlift.bytecode.BytecodeNode;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.relational.RowExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionCallCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        FunctionRegistry registry = context.getRegistry();
        ScalarFunctionImplementation function = registry.getScalarFunctionImplementation(signature);
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        for (int i = 0; i < arguments.size(); ++i) {
            RowExpression argument = arguments.get(i);
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = function.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                argumentsBytecode.add(context.generate(argument));
                continue;
            }
            argumentsBytecode.add(context.generate(argument, Optional.of(argumentProperty.getLambdaInterface())));
        }
        return context.generateCall(signature.getName(), function, argumentsBytecode);
    }
}

