/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CompilerOperations;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;

public class IfCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        Variable wasNull = context.wasNull();
        BytecodeBlock condition = new BytecodeBlock().append(context.generate(arguments.get(0))).comment("... and condition value was not null").append((BytecodeNode)wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, new Class[]{Boolean.TYPE}).invokeStatic(CompilerOperations.class, "and", Boolean.TYPE, new Class[]{Boolean.TYPE, Boolean.TYPE}).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        return new IfStatement().condition((BytecodeNode)condition).ifTrue(context.generate(arguments.get(1))).ifFalse(context.generate(arguments.get(2)));
    }
}

