/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;

public class NullIfCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Scope scope = generatorContext.getScope();
        RowExpression first = arguments.get(0);
        RowExpression second = arguments.get(1);
        LabelNode notMatch = new LabelNode("notMatch");
        Variable firstValue = scope.createTempVariable(first.getType().getJavaType());
        BytecodeBlock block = new BytecodeBlock().comment("check if first arg is null").append(generatorContext.generate(first)).append(BytecodeUtils.ifWasNullPopAndGoto(scope, notMatch, Void.TYPE, new Class[0])).dup(first.getType().getJavaType()).putVariable(firstValue);
        Type firstType = first.getType();
        Type secondType = second.getType();
        Signature equalsSignature = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)firstType, (Object)secondType));
        ScalarFunctionImplementation equalsFunction = generatorContext.getRegistry().getScalarFunctionImplementation(equalsSignature);
        BytecodeNode equalsCall = generatorContext.generateCall(equalsSignature.getName(), equalsFunction, (List<BytecodeNode>)ImmutableList.of((Object)NullIfCodeGenerator.cast(generatorContext, (BytecodeNode)firstValue, firstType, equalsSignature.getArgumentTypes().get(0)), (Object)NullIfCodeGenerator.cast(generatorContext, generatorContext.generate(second), secondType, equalsSignature.getArgumentTypes().get(1))));
        BytecodeBlock conditionBlock = new BytecodeBlock().append(equalsCall).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, notMatch, Void.TYPE, Boolean.TYPE));
        BytecodeBlock trueBlock = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pop(first.getType().getJavaType()).pushJavaDefault(first.getType().getJavaType());
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)conditionBlock).ifTrue((BytecodeNode)trueBlock).ifFalse((BytecodeNode)notMatch));
        return block;
    }

    private static BytecodeNode cast(BytecodeGeneratorContext generatorContext, BytecodeNode argument, Type actualType, TypeSignature requiredType) {
        if (actualType.getTypeSignature().equals((Object)requiredType)) {
            return argument;
        }
        Signature function = generatorContext.getRegistry().getCoercion(actualType.getTypeSignature(), requiredType);
        return generatorContext.generateCall(function.getName(), generatorContext.getRegistry().getScalarFunctionImplementation(function), (List<BytecodeNode>)ImmutableList.of((Object)argument));
    }
}

