/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.Constant;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.sql.gen.AndCodeGenerator;
import io.prestosql.sql.gen.BindCodeGenerator;
import io.prestosql.sql.gen.Binding;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.CastCodeGenerator;
import io.prestosql.sql.gen.CoalesceCodeGenerator;
import io.prestosql.sql.gen.DereferenceCodeGenerator;
import io.prestosql.sql.gen.FunctionCallCodeGenerator;
import io.prestosql.sql.gen.IfCodeGenerator;
import io.prestosql.sql.gen.InCodeGenerator;
import io.prestosql.sql.gen.IsNullCodeGenerator;
import io.prestosql.sql.gen.LambdaBytecodeGenerator;
import io.prestosql.sql.gen.NullIfCodeGenerator;
import io.prestosql.sql.gen.OrCodeGenerator;
import io.prestosql.sql.gen.RowConstructorCodeGenerator;
import io.prestosql.sql.gen.SwitchCodeGenerator;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.Signatures;
import io.prestosql.sql.relational.VariableReferenceExpression;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RowExpressionCompiler {
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler;
    private final FunctionRegistry registry;
    private final Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap;

    RowExpressionCompiler(CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler, FunctionRegistry registry, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap) {
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.fieldReferenceCompiler = fieldReferenceCompiler;
        this.registry = registry;
        this.compiledLambdaMap = compiledLambdaMap;
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope) {
        return this.compile(rowExpression, scope, Optional.empty());
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope, Optional<Class> lambdaInterface) {
        return rowExpression.accept(new Visitor(), new Context(scope, lambdaInterface));
    }

    private static class Context {
        private final Scope scope;
        private final Optional<Class> lambdaInterface;

        public Context(Scope scope, Optional<Class> lambdaInterface) {
            this.scope = scope;
            this.lambdaInterface = lambdaInterface;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Optional<Class> getLambdaInterface() {
            return this.lambdaInterface;
        }
    }

    private class Visitor
    implements RowExpressionVisitor<BytecodeNode, Context> {
        private Visitor() {
        }

        @Override
        public BytecodeNode visitCall(CallExpression call, Context context) {
            BytecodeGenerator generator;
            if (call.getSignature().getName().equals(Signatures.CAST)) {
                generator = new CastCodeGenerator();
            } else {
                switch (call.getSignature().getName()) {
                    case "IF": {
                        generator = new IfCodeGenerator();
                        break;
                    }
                    case "NULL_IF": {
                        generator = new NullIfCodeGenerator();
                        break;
                    }
                    case "SWITCH": {
                        generator = new SwitchCodeGenerator();
                        break;
                    }
                    case "IS_NULL": {
                        generator = new IsNullCodeGenerator();
                        break;
                    }
                    case "COALESCE": {
                        generator = new CoalesceCodeGenerator();
                        break;
                    }
                    case "IN": {
                        generator = new InCodeGenerator(RowExpressionCompiler.this.registry);
                        break;
                    }
                    case "AND": {
                        generator = new AndCodeGenerator();
                        break;
                    }
                    case "OR": {
                        generator = new OrCodeGenerator();
                        break;
                    }
                    case "DEREFERENCE": {
                        generator = new DereferenceCodeGenerator();
                        break;
                    }
                    case "ROW_CONSTRUCTOR": {
                        generator = new RowConstructorCodeGenerator();
                        break;
                    }
                    case "$INTERNAL$BIND": {
                        generator = new BindCodeGenerator(RowExpressionCompiler.this.compiledLambdaMap, context.getLambdaInterface().get());
                        break;
                    }
                    default: {
                        generator = new FunctionCallCodeGenerator();
                    }
                }
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.registry);
            return generator.generateExpression(call.getSignature(), generatorContext, call.getType(), call.getArguments());
        }

        @Override
        public BytecodeNode visitConstant(ConstantExpression constant, Context context) {
            Object value = constant.getValue();
            Class javaType = constant.getType().getJavaType();
            BytecodeBlock block = new BytecodeBlock();
            if (value == null) {
                return block.comment("constant null").append((BytecodeNode)context.getScope().getVariable("wasNull").set(BytecodeExpressions.constantTrue())).pushJavaDefault(javaType);
            }
            block.comment("constant " + constant.getType().getTypeSignature());
            if (javaType == Boolean.TYPE) {
                return block.append((BytecodeNode)Constant.loadBoolean((boolean)((Boolean)value)));
            }
            if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE) {
                return block.append((BytecodeNode)Constant.loadInt((int)((Number)value).intValue()));
            }
            if (javaType == Long.TYPE) {
                return block.append((BytecodeNode)Constant.loadLong((long)((Long)value)));
            }
            if (javaType == Float.TYPE) {
                return block.append((BytecodeNode)Constant.loadFloat((float)((Float)value).floatValue()));
            }
            if (javaType == Double.TYPE) {
                return block.append((BytecodeNode)Constant.loadDouble((double)((Double)value)));
            }
            if (javaType == String.class) {
                return block.append((BytecodeNode)Constant.loadString((String)((String)value)));
            }
            Binding binding = RowExpressionCompiler.this.callSiteBinder.bind(value, constant.getType().getJavaType());
            return new BytecodeBlock().setDescription("constant " + constant.getType()).comment(constant.toString()).append((BytecodeNode)BytecodeUtils.loadConstant(binding));
        }

        @Override
        public BytecodeNode visitInputReference(InputReferenceExpression node, Context context) {
            return (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitInputReference(node, context.getScope());
        }

        @Override
        public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Context context) {
            Preconditions.checkState((boolean)RowExpressionCompiler.this.compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
            if (!((Class)context.lambdaInterface.get()).isAnnotationPresent(FunctionalInterface.class)) {
                throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.registry);
            return LambdaBytecodeGenerator.generateLambda(generatorContext, (List<RowExpression>)ImmutableList.of(), (LambdaBytecodeGenerator.CompiledLambda)RowExpressionCompiler.this.compiledLambdaMap.get(lambda), context.getLambdaInterface().get());
        }

        @Override
        public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Context context) {
            return (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitVariableReference(reference, context.getScope());
        }
    }
}

