/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DesugarAtTimeZoneRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes), (Expression)expression);
    }

    private DesugarAtTimeZoneRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, SymbolAllocator symbolAllocator) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        return DesugarAtTimeZoneRewriter.rewrite(expression, expressionTypes);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        public Expression rewriteAtTimeZone(AtTimeZone node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            Type type = this.getType(node.getValue());
            if (type.equals(TimeType.TIME)) {
                value = new Cast(value, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getDisplayName());
            } else if (type.equals(TimestampType.TIMESTAMP)) {
                value = new Cast(value, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getDisplayName());
            }
            return new FunctionCall(QualifiedName.of((String)"at_timezone"), (List)ImmutableList.of((Object)value, (Object)treeRewriter.rewrite(node.getTimeZone(), (Object)context)));
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

