/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.TryExpression;
import java.util.List;

public class DesugarTryExpressionRewriter {
    private DesugarTryExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteTryExpression(TryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression expression = treeRewriter.rewrite(node.getInnerExpression(), (Object)context);
            return new FunctionCall(QualifiedName.of((String)"$internal$try"), (List)ImmutableList.of((Object)new LambdaExpression((List)ImmutableList.of(), expression)));
        }
    }
}

