/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor().process((Node)expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (node.getName().equals((Object)QualifiedName.of((String)"rand")) || node.getName().equals((Object)QualifiedName.of((String)"random")) || node.getName().equals((Object)QualifiedName.of((String)"shuffle"))) {
                deterministic.set(false);
            }
            return (Void)super.visitFunctionCall(node, (Object)deterministic);
        }
    }
}

