/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.Column;
import io.prestosql.execution.Input;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extractInputs(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept(visitor, null);
        return ImmutableList.copyOf(visitor.getInputs());
    }

    private static Column createColumn(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString());
    }

    private Input createInput(Session session, TableHandle table, Set<Column> columns) {
        SchemaTableName schemaTable = this.metadata.getTableMetadata(session, table).getTable();
        Optional<Object> inputMetadata = this.metadata.getInfo(session, table);
        return new Input(table.getCatalogName(), schemaTable.getSchemaName(), schemaTable.getTableName(), inputMetadata, (List<Column>)ImmutableList.copyOf(columns));
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final ImmutableSet.Builder<Input> inputs = ImmutableSet.builder();

        private Visitor() {
        }

        public Set<Input> getInputs() {
            return this.inputs.build();
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle tableHandle = node.getTable();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.session, tableHandle, columns));
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            TableHandle tableHandle = node.getTableHandle();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.session, tableHandle, columns));
            return null;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }
}

