/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.scalar.VarbinaryFunctions;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Objects;

public final class LiteralEncoder {
    private final BlockEncodingSerde blockEncodingSerde;

    public LiteralEncoder(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public Expression toExpression(Object object, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast((Expression)new NullLiteral(), type.getTypeSignature().toString(), false, true);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new GenericLiteral("TINYINT", object.toString());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new GenericLiteral("SMALLINT", object.toString());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            LongLiteral expression = new LongLiteral(object.toString());
            if (expression.getValue() >= Integer.MIN_VALUE && expression.getValue() <= Integer.MAX_VALUE) {
                return new GenericLiteral("BIGINT", object.toString());
            }
            return new LongLiteral(object.toString());
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(object), (String)"object.getClass (%s) and type.getJavaType (%s) do not agree", object.getClass(), (Object)type.getJavaType());
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of());
            }
            if (value.equals(Double.NEGATIVE_INFINITY)) {
                return ArithmeticUnaryExpression.negative((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()));
            }
            if (value.equals(Double.POSITIVE_INFINITY)) {
                return new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of());
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(RealType.REAL)) {
            Float value = Float.valueOf(Float.intBitsToFloat(((Long)object).intValue()));
            if (value.isNaN()) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of()), "real");
            }
            if (value.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return ArithmeticUnaryExpression.negative((Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real"));
            }
            if (value.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real");
            }
            return new GenericLiteral("REAL", value.toString());
        }
        if (type instanceof DecimalType) {
            String string = Decimals.isShortDecimal((Type)type) ? Decimals.toString((long)((Long)object), (int)((DecimalType)type).getScale()) : Decimals.toString((Slice)((Slice)object), (int)((DecimalType)type).getScale());
            return new Cast((Expression)new DecimalLiteral(string), type.getDisplayName());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Slice value = (Slice)object;
            StringLiteral stringLiteral = new StringLiteral(value.toStringUtf8());
            if (!varcharType.isUnbounded() && varcharType.getBoundedLength() == SliceUtf8.countCodePoints((Slice)value)) {
                return stringLiteral;
            }
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, true);
        }
        if (type instanceof CharType) {
            StringLiteral stringLiteral = new StringLiteral(((Slice)object).toStringUtf8());
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, true);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral("DATE", new SqlDate(Math.toIntExact((Long)object)).toString());
        }
        if (object instanceof Block) {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(((Block)object).getSizeInBytes()));
            BlockSerdeUtil.writeBlock(this.blockEncodingSerde, (SliceOutput)output, (Block)object);
            object = output.slice();
        }
        if (object instanceof Slice) {
            FunctionCall fromBase64 = new FunctionCall(QualifiedName.of((String)"from_base64"), (List)ImmutableList.of((Object)new StringLiteral(VarbinaryFunctions.toBase64((Slice)object).toStringUtf8())));
            Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature(type);
            return new FunctionCall(QualifiedName.of((String)signature.getName()), (List)ImmutableList.of((Object)fromBase64));
        }
        Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature(type);
        Expression rawLiteral = this.toExpression(object, FunctionRegistry.typeForMagicLiteral(type));
        return new FunctionCall(QualifiedName.of((String)signature.getName()), (List)ImmutableList.of((Object)rawLiteral));
    }
}

