/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.type.JsonType;
import io.prestosql.util.DateTimeUtils;
import java.util.List;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(Metadata metadata, ConnectorSession session, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(metadata).process((Node)node, session);
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, ConnectorSession> {
        private final Metadata metadata;
        private final InterpretedFunctionInvoker functionInvoker;

        private LiteralVisitor(Metadata metadata) {
            this.metadata = metadata;
            this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionRegistry());
        }

        protected Object visitLiteral(Literal node, ConnectorSession session) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, ConnectorSession context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, ConnectorSession session) {
            return node.getSlice();
        }

        protected Object visitCharLiteral(CharLiteral node, ConnectorSession context) {
            return node.getSlice();
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitGenericLiteral(GenericLiteral node, ConnectorSession session) {
            Type type = this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (JsonType.JSON.equals(type)) {
                Signature operatorSignature = new Signature("json_parse", FunctionKind.SCALAR, JsonType.JSON.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature());
                return this.functionInvoker.invoke(operatorSignature, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            try {
                Signature signature = this.metadata.getFunctionRegistry().getCoercion((Type)VarcharType.VARCHAR, type);
                return this.functionInvoker.invoke(signature, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
            }
        }

        protected Long visitTimeLiteral(TimeLiteral node, ConnectorSession session) {
            if (session.isLegacyTimestamp()) {
                return DateTimeUtils.parseTimeLiteral(session.getTimeZoneKey(), node.getValue());
            }
            return DateTimeUtils.parseTimeLiteral(node.getValue());
        }

        protected Long visitTimestampLiteral(TimestampLiteral node, ConnectorSession session) {
            try {
                if (session.isLegacyTimestamp()) {
                    return DateTimeUtils.parseTimestampLiteral(session.getTimeZoneKey(), node.getValue());
                }
                return DateTimeUtils.parseTimestampLiteral(node.getValue());
            }
            catch (RuntimeException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, ConnectorSession session) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, ConnectorSession session) {
            return null;
        }
    }
}

