/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.TryExpression;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private NullabilityAnalyzer() {
    }

    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process((Node)expression, result);
        return result.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitCast(Cast node, AtomicBoolean result) {
            result.set(node.isSafe() || !node.isTypeOnly());
            return null;
        }

        protected Void visitNullIfExpression(NullIfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitInPredicate(InPredicate node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSubscriptExpression(SubscriptExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitTryExpression(TryExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitIfExpression(IfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean result) {
            result.set(true);
            return null;
        }
    }
}

