/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Output;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.TableWriterNode;
import java.util.Optional;

public class OutputExtractor {
    public Optional<Output> extractOutput(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept(visitor, null);
        if (visitor.getCatalogName() == null) {
            return Optional.empty();
        }
        return Optional.of(new Output(visitor.getCatalogName(), visitor.getSchemaTableName().getSchemaName(), visitor.getSchemaTableName().getTableName()));
    }

    private static class Visitor
    extends PlanVisitor<Void, Void> {
        private CatalogName catalogName;
        private SchemaTableName schemaTableName;

        private Visitor() {
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            TableWriterNode.WriterTarget writerTarget = node.getTarget();
            if (writerTarget instanceof TableWriterNode.CreateHandle) {
                this.catalogName = ((TableWriterNode.CreateHandle)writerTarget).getHandle().getCatalogName();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.CreateHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.CreateHandle)writerTarget).getSchemaTableName();
            }
            if (writerTarget instanceof TableWriterNode.InsertHandle) {
                this.catalogName = ((TableWriterNode.InsertHandle)writerTarget).getHandle().getCatalogName();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.InsertHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.InsertHandle)writerTarget).getSchemaTableName();
            }
            if (writerTarget instanceof TableWriterNode.DeleteHandle) {
                this.catalogName = ((TableWriterNode.DeleteHandle)writerTarget).getHandle().getCatalogName();
                Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)((TableWriterNode.DeleteHandle)writerTarget).getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
                this.schemaTableName = ((TableWriterNode.DeleteHandle)writerTarget).getSchemaTableName();
            }
            return null;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }
    }
}

