/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Parameter;
import java.util.List;
import java.util.Objects;

public class ParameterRewriter
extends ExpressionRewriter<Void> {
    private final List<Expression> parameterValues;
    private final Analysis analysis;

    public ParameterRewriter(List<Expression> parameterValues) {
        Objects.requireNonNull(parameterValues, "parameterValues is null");
        this.parameterValues = parameterValues;
        this.analysis = null;
    }

    public ParameterRewriter(List<Expression> parameterValues, Analysis analysis) {
        Objects.requireNonNull(parameterValues, "parameterValues is null");
        this.parameterValues = parameterValues;
        this.analysis = analysis;
    }

    public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return treeRewriter.defaultRewrite(node, (Object)context);
    }

    public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkState((this.parameterValues.size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.coerceIfNecessary((Expression)node, this.parameterValues.get(node.getPosition()));
    }

    private Expression coerceIfNecessary(Expression original, Expression rewritten) {
        if (this.analysis == null) {
            return rewritten;
        }
        Type coercion = this.analysis.getCoercion(original);
        if (coercion != null) {
            rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.analysis.isTypeOnlyCoercion(original));
        }
        return rewritten;
    }
}

