/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.CurrentTime;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Optional;

public class CanonicalizeExpressionRewriter {
    private CanonicalizeExpressionRewriter() {
    }

    public static Expression canonicalizeExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            switch (node.getFunction()) {
                case DATE: {
                    return new FunctionCall(QualifiedName.of((String)"current_date"), (List)ImmutableList.of());
                }
                case TIME: {
                    return new FunctionCall(QualifiedName.of((String)"current_time"), (List)ImmutableList.of());
                }
                case LOCALTIME: {
                    return new FunctionCall(QualifiedName.of((String)"localtime"), (List)ImmutableList.of());
                }
                case TIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"current_timestamp"), (List)ImmutableList.of());
                }
                case LOCALTIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"localtimestamp"), (List)ImmutableList.of());
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getFunction());
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            switch (node.getField()) {
                case YEAR: {
                    return new FunctionCall(QualifiedName.of((String)"year"), (List)ImmutableList.of((Object)value));
                }
                case QUARTER: {
                    return new FunctionCall(QualifiedName.of((String)"quarter"), (List)ImmutableList.of((Object)value));
                }
                case MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"month"), (List)ImmutableList.of((Object)value));
                }
                case WEEK: {
                    return new FunctionCall(QualifiedName.of((String)"week"), (List)ImmutableList.of((Object)value));
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"day"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_week"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_year"), (List)ImmutableList.of((Object)value));
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return new FunctionCall(QualifiedName.of((String)"year_of_week"), (List)ImmutableList.of((Object)value));
                }
                case HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"hour"), (List)ImmutableList.of((Object)value));
                }
                case MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"minute"), (List)ImmutableList.of((Object)value));
                }
                case SECOND: {
                    return new FunctionCall(QualifiedName.of((String)"second"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_minute"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_hour"), (List)ImmutableList.of((Object)value));
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }
    }
}

