/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import io.prestosql.SystemSessionProperties;
import io.prestosql.cost.CostCalculatorWithEstimatedExchanges;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.LocalCostEstimate;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsProvider;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PlanNodeWithCost;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class DetermineSemiJoinDistributionType
implements Rule<SemiJoinNode> {
    private final TaskCountEstimator taskCountEstimator;
    private final CostComparator costComparator;
    private static final Pattern<SemiJoinNode> PATTERN = Patterns.semiJoin().matching(semiJoin -> !semiJoin.getDistributionType().isPresent());

    public DetermineSemiJoinDistributionType(CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public Pattern<SemiJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SemiJoinNode semiJoinNode, Captures captures, Rule.Context context) {
        FeaturesConfig.JoinDistributionType joinDistributionType = SystemSessionProperties.getJoinDistributionType(context.getSession());
        switch (joinDistributionType) {
            case AUTOMATIC: {
                return Rule.Result.ofPlanNode(this.getCostBasedDistributionType(semiJoinNode, context));
            }
            case PARTITIONED: {
                return Rule.Result.ofPlanNode(semiJoinNode.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED));
            }
            case BROADCAST: {
                return Rule.Result.ofPlanNode(semiJoinNode.withDistributionType(SemiJoinNode.DistributionType.REPLICATED));
            }
        }
        throw new IllegalArgumentException("Unknown join_distribution_type: " + (Object)((Object)joinDistributionType));
    }

    private PlanNode getCostBasedDistributionType(SemiJoinNode node, Rule.Context context) {
        if (!this.canReplicate(node, context)) {
            return node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED);
        }
        ArrayList<PlanNodeWithCost> possibleJoinNodes = new ArrayList<PlanNodeWithCost>();
        possibleJoinNodes.add(this.getSemiJoinNodeWithCost(node.withDistributionType(SemiJoinNode.DistributionType.REPLICATED), context));
        possibleJoinNodes.add(this.getSemiJoinNodeWithCost(node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED), context));
        if (possibleJoinNodes.stream().anyMatch(result -> result.getCost().hasUnknownComponents())) {
            return node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED);
        }
        Ordering planNodeOrderings = this.costComparator.forSession(context.getSession()).onResultOf(PlanNodeWithCost::getCost);
        return ((PlanNodeWithCost)planNodeOrderings.min(possibleJoinNodes)).getPlanNode();
    }

    private boolean canReplicate(SemiJoinNode node, Rule.Context context) {
        Optional<DataSize> joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        if (!joinMaxBroadcastTableSize.isPresent()) {
            return true;
        }
        PlanNode buildSide = node.getFilteringSource();
        PlanNodeStatsEstimate buildSideStatsEstimate = context.getStatsProvider().getStats(buildSide);
        double buildSideSizeInBytes = buildSideStatsEstimate.getOutputSizeInBytes(buildSide.getOutputSymbols(), context.getSymbolAllocator().getTypes());
        return buildSideSizeInBytes <= (double)joinMaxBroadcastTableSize.get().toBytes();
    }

    private PlanNodeWithCost getSemiJoinNodeWithCost(SemiJoinNode possibleJoinNode, Rule.Context context) {
        TypeProvider types = context.getSymbolAllocator().getTypes();
        StatsProvider stats = context.getStatsProvider();
        boolean replicated = possibleJoinNode.getDistributionType().get().equals((Object)SemiJoinNode.DistributionType.REPLICATED);
        int estimatedSourceDistributedTaskCount = this.taskCountEstimator.estimateSourceDistributedTaskCount();
        LocalCostEstimate cost = CostCalculatorWithEstimatedExchanges.calculateJoinCostWithoutOutput(possibleJoinNode.getSource(), possibleJoinNode.getFilteringSource(), stats, types, replicated, estimatedSourceDistributedTaskCount);
        return new PlanNodeWithCost(cost.toPlanCost(), possibleJoinNode);
    }
}

