/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;

public class ImplementBernoulliSampleAsFilter
implements Rule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.BERNOULLI));

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new FilterNode(sample.getId(), sample.getSource(), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(Double.toString(sample.getSampleRatio())))));
    }
}

