/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(ImplementFilteredAggregations::hasFilters);

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getCall().getFilter().isPresent() && !e.getMask().isPresent());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregation, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        ImmutableList.Builder maskSymbols = ImmutableList.builder();
        boolean aggregateWithoutFilterPresent = false;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregation.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            FunctionCall call = entry.getValue().getCall();
            Optional<Symbol> mask = entry.getValue().getMask();
            if (call.getFilter().isPresent()) {
                Expression filter = (Expression)call.getFilter().get();
                Symbol symbol = context.getSymbolAllocator().newSymbol(filter, (Type)BooleanType.BOOLEAN);
                Verify.verify((!mask.isPresent() ? 1 : 0) != 0, (String)"Expected aggregation without mask symbols, see Rule pattern", (Object[])new Object[0]);
                newAssignments.put(symbol, filter);
                mask = Optional.of(symbol);
                maskSymbols.add((Object)symbol.toSymbolReference());
            } else {
                aggregateWithoutFilterPresent = true;
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(new FunctionCall(call.getName(), call.getWindow(), Optional.empty(), call.getOrderBy(), call.isDistinct(), call.getArguments()), entry.getValue().getSignature(), mask));
        }
        BooleanLiteral predicate = BooleanLiteral.TRUE_LITERAL;
        if (!aggregation.hasNonEmptyGroupingSet() && !aggregateWithoutFilterPresent) {
            predicate = ExpressionUtils.combineDisjunctsWithDefault((Collection<Expression>)maskSymbols.build(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
        newAssignments.putIdentities(aggregation.getSource().getOutputSymbols());
        return Rule.Result.ofPlanNode(new AggregationNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), aggregation.getSource(), newAssignments.build()), (Expression)predicate), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregation.getGroupingSets(), (List<Symbol>)ImmutableList.of(), aggregation.getStep(), aggregation.getHashSymbol(), aggregation.getGroupIdSymbol()));
    }
}

