/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ImplementOffsetOverProjectTopN
implements Rule<OffsetNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<TopNNode> TOPN = Capture.newCapture();
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset().with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT).matching(ProjectNode::isIdentity).with(Patterns.source().matching(Patterns.topN().capturedAs(TOPN)))));

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        TopNNode topN = (TopNNode)captures.get(TOPN);
        Symbol rowNumberSymbol = context.getSymbolAllocator().newSymbol("row_number", (Type)BigintType.BIGINT);
        RowNumberNode rowNumberNode = new RowNumberNode(context.getIdAllocator().getNextId(), topN, (List<Symbol>)ImmutableList.of(), rowNumberSymbol, Optional.empty(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), rowNumberNode, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)rowNumberSymbol.toSymbolReference(), (Expression)new GenericLiteral("BIGINT", Long.toString(parent.getCount()))));
        SortNode sortNode = new SortNode(context.getIdAllocator().getNextId(), filterNode, new OrderingScheme((List<Symbol>)ImmutableList.of((Object)rowNumberSymbol), (Map<Symbol, SortOrder>)ImmutableMap.of((Object)rowNumberSymbol, (Object)SortOrder.ASC_NULLS_FIRST)));
        ProjectNode projectNode = (ProjectNode)project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)sortNode));
        return Rule.Result.ofPlanNode(projectNode);
    }
}

